// ConnectedApplication.cpp : main project file.

#include "stdafx.h"

using namespace System;
// Generic ADO.NET definitions
using namespace System::Data;
// Specific definitions for the OleDb data provider
using namespace System::Data::OleDb;

int main(array<System::String ^> ^args)
{
    // Create the connection
	OleDbConnection ^ cnNwind = gcnew OleDbConnection();

	// Set the connection string
	cnNwind->ConnectionString =
    L" Provider=Microsoft.Jet.OLEDB.4.0; "
    L"Data Source=C:\\temp\\northwind.mdb";

	try
	{
		// Open the database
		cnNwind->Open();
		Console::WriteLine(L"Connected to database successfully!");

		// Count the customers
		OleDbCommand ^ cmProducts = gcnew OleDbCommand();
		cmProducts->CommandText = L"SELECT COUNT(*) FROM Products";
		cmProducts->CommandType = CommandType::Text;
		cmProducts->Connection = cnNwind;

		// Print the result
		Object ^ numberOfProducts = cmProducts->ExecuteScalar();
		Console::Write(L"Number of products: ");
		Console::WriteLine(numberOfProducts);

		// Update the prices of products
		cmProducts->CommandText = L"UPDATE products SET UnitPrice = "
                          L"UnitPrice * 1.05 ";

		int rowsAffected = cmProducts->ExecuteNonQuery();
		Console::Write(L"Number of products increased in price: ");
		Console::WriteLine(rowsAffected);

		// Query the database
		cmProducts->CommandText = L"SELECT ProductName, UnitPrice FROM Products";

		OleDbDataReader ^ reader = cmProducts->ExecuteReader();

		Console::WriteLine(L"\n------------------------------------");
		while (reader->Read())
		{
			Console::Write(reader->GetString(0));
			Console::Write(L", ");
			Console::WriteLine(reader->GetDecimal(1));
		}
		Console::WriteLine(L"--------------------------------------");
		reader->Close();
	}
	catch (OleDbException ^ pe)
	{
		Console::Write(L"Error occurred: ");
		Console::WriteLine(pe->Message);
	}

	// Close the connection
	if (cnNwind->State != ConnectionState::Closed)
	{
		cnNwind->Close();
	}
	Console::WriteLine(L"The database connection is closed...");

    return 0;
}
