#pragma once

namespace CppDraw {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Drawing::Drawing2D;
	using namespace System::Drawing::Printing;


	/// <summary>
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the
	///          'Resource File Name' property for the managed resource compiler tool
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>

	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Point p1, p2;
	private: System::Windows::Forms::MenuStrip^  menuStrip1;
	public: 
	private: System::Windows::Forms::ToolStripMenuItem^  fileToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  printItem;
	private: System::Windows::Forms::ToolStripSeparator^  toolStripSeparator1;
	private: System::Windows::Forms::ToolStripMenuItem^  exitItem;

	 	public:



		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: Add the constructor code here
			//
			list = gcnew ArrayList();
			// Create the Font
			font1 = gcnew System::Drawing::Font("Verdana", 8, FontStyle::Regular, GraphicsUnit::Millimeter);
		}

		void PrintAPage(Object^ pSender, PrintPageEventArgs^ pe)
		{
			Graphics^ gr = pe->Graphics;
			Pen^ pen1 = gcnew Pen(Color::Black);

			// Draw the image
			Bitmap^ bmp = gcnew Bitmap(L"ramp1.gif");
			gr->DrawImage(bmp, 10,10);

			for(int i=0; i<list->Count; i++)
			{
				Line^ pl = dynamic_cast<Line^>(list->default[i]);
				gr->DrawLine(pen1, pl->p1.X,pl->p1.Y, pl->p2.X,pl->p2.Y);
			}
		}

	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::Button^  drawBtn;
	private: System::Drawing::Font^ font1;
	protected: 

	private:
		ArrayList^ list;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

	private:
		ref struct Line
		{
			Point p1;
			Point p2;
		};

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->drawBtn = (gcnew System::Windows::Forms::Button());
			this->menuStrip1 = (gcnew System::Windows::Forms::MenuStrip());
			this->fileToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->printItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->exitItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->toolStripSeparator1 = (gcnew System::Windows::Forms::ToolStripSeparator());
			this->menuStrip1->SuspendLayout();
			this->SuspendLayout();
			// 
			// drawBtn
			// 
			this->drawBtn->Location = System::Drawing::Point(200, 200);
			this->drawBtn->Name = L"drawBtn";
			this->drawBtn->Size = System::Drawing::Size(75, 23);
			this->drawBtn->TabIndex = 0;
			this->drawBtn->Text = L"Draw";
			this->drawBtn->UseVisualStyleBackColor = true;
			this->drawBtn->Click += gcnew System::EventHandler(this, &Form1::drawBtn_Click);
			// 
			// menuStrip1
			// 
			this->menuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->fileToolStripMenuItem});
			this->menuStrip1->Location = System::Drawing::Point(0, 0);
			this->menuStrip1->Name = L"menuStrip1";
			this->menuStrip1->Size = System::Drawing::Size(292, 24);
			this->menuStrip1->TabIndex = 1;
			this->menuStrip1->Text = L"menuStrip1";
			// 
			// fileToolStripMenuItem
			// 
			this->fileToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(3) {this->printItem, 
				this->toolStripSeparator1, this->exitItem});
			this->fileToolStripMenuItem->Name = L"fileToolStripMenuItem";
			this->fileToolStripMenuItem->Size = System::Drawing::Size(35, 20);
			this->fileToolStripMenuItem->Text = L"File";
			// 
			// printItem
			// 
			this->printItem->Name = L"printItem";
			this->printItem->Size = System::Drawing::Size(152, 22);
			this->printItem->Text = L"&Print";
			this->printItem->Click += gcnew System::EventHandler(this, &Form1::printItem_Click);
			// 
			// exitItem
			// 
			this->exitItem->Name = L"exitItem";
			this->exitItem->Size = System::Drawing::Size(152, 22);
			this->exitItem->Text = L"E&xit";
			this->exitItem->Click += gcnew System::EventHandler(this, &Form1::exitItem_Click);
			// 
			// toolStripSeparator1
			// 
			this->toolStripSeparator1->Name = L"toolStripSeparator1";
			this->toolStripSeparator1->Size = System::Drawing::Size(149, 6);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(292, 266);
			this->Controls->Add(this->drawBtn);
			this->Controls->Add(this->menuStrip1);
			this->MainMenuStrip = this->menuStrip1;
			this->Name = L"Form1";
			this->Text = L"Drawing";
			this->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Form1::Form1_Paint);
			this->MouseUp += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::Form1_MouseUp);
			this->MouseDown += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::Form1_MouseDown);
			this->menuStrip1->ResumeLayout(false);
			this->menuStrip1->PerformLayout();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion

private: System::Void drawBtn_Click(System::Object^  sender, System::EventArgs^  e)
{
	// Get a Graphics object
    Graphics^ pg = CreateGraphics();

    // Get a Pen
    Pen^ pen1 = gcnew Pen(Color::Red);

    // Draw a line
	pg->DrawLine(pen1, 20, 20, 100, 250);

	// Draw a styled line
	Pen^ pen2 = gcnew Pen(Color::Blue, 3.0);
	pen2->DashStyle = DashStyle::DashDotDot;
	pg->DrawLine(pen2, 10, 120, 250, 60);

	// Draw a filled rectangle
	SolidBrush^ sb1 = gcnew SolidBrush(Color::Red);
	pg->FillRectangle(sb1, 60,30, 40,40);

	// Draw a filled and outlined rectangle
	SolidBrush^ sb2 = gcnew SolidBrush(Color::Yellow);
	pg->FillRectangle(sb2, 90, 40, 45, 45);
	pg->DrawRectangle(pen1, 90, 40, 45, 45);

	// Draw a filled ellipse
	SolidBrush^ sb3 = gcnew SolidBrush(Color::Green);
	pg->FillEllipse(sb3, 30,100, 65, 50);

    // Dispose of the Graphics object
	delete pg;
}
	private: System::Void Form1_MouseDown(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e)
	{
		p1.X = e->X;
		p1.Y = e->Y;
	}
	private: System::Void Form1_MouseUp(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e)
	{
		Graphics^ gr = CreateGraphics();
		Pen^ pen1 = gcnew Pen(Color::Black);

		if (e->Button == ::CppDraw::MouseButtons::Left)
		{
			// Draw lines
			p2.X = e->X;
			p2.Y = e->Y;

			gr->DrawLine(pen1, p1.X,p1.Y, p2.X,p2.Y);

			// Add a new line to the list
			Line^ pl = gcnew Line();
			pl->p1 = p1;
			pl->p2 = p2;
			list->Add(pl);
		}
		else if (e->Button == ::CppDraw::MouseButtons::Right)
		{
			// Draw text
			gr->DrawString(L"Right click Text", font1, Brushes::Black, (float)e->X,
				(float)e->Y);
		}
		delete gr;
	 }
private: System::Void Form1_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e)
{
	Graphics^ gr = e->Graphics;
    Pen^ pen1 = gcnew Pen(Color::Black);

	// Count member - Used to get the number of elements actually
	// contained in the ArrayList.
    for(int i=0; i<list->Count; i++)
    {
		// Use default for the Item ArrayList member
		// Item's property of the ArrayList member - Used to get or sets the
		// element at the specified index.
		// Then, cast to the Line^ type and assign to pline variable
		Line^ pline = dynamic_cast<Line^>(list->default[i]);
        gr->DrawLine(pen1, pline->p1.X, pline->p1.Y, pline->p2.X, pline->p2.Y);
    }
	
	// Draw the image
	Bitmap^ bmp = gcnew Bitmap(L"ramp1.gif");
	gr->DrawImage(bmp, 10,10);

	//// Or, Create image.
    //Image^ newImage = Image::FromFile("ramp1.gif");

    //// Create Point for upper-left corner of image.
    // Point ulCorner = Point(10,10);
	// gr->DrawImage(newImage, ulCorner);

}
private: System::Void printItem_Click(System::Object^  sender, System::EventArgs^  e)
{
	// The PrintDocument holds the settings
	PrintDocument^ pdoc = gcnew PrintDocument();
	// Create a dialog and attach it to the document
	PrintDialog^ pd = gcnew PrintDialog();
	pd->Document = pdoc;

	// Show the dialog
	if (pd->ShowDialog() == ::CppDraw::DialogResult::OK)
	{
		// Add the page handler, PrintAPAge is a call back function
		pdoc->PrintPage += gcnew PrintPageEventHandler(this, &Form1::PrintAPage);
		// Print the page
		pdoc->Print();
	}
	else
		MessageBox::Show("Print cancelled", "Information");
}
private: System::Void exitItem_Click(System::Object^  sender, System::EventArgs^  e) 
{
	// Just exit the application
	Application::Exit();
}
};
}







