// CppReader.cpp : main project file.
// Run at command prompt
#include "stdafx.h"

using namespace System;
using namespace System::IO;

int main()
{
	// Get the command line arguments
	array<String^>^args = Environment::GetCommandLineArgs();

    // Check for required arguments number...
	if (args->Length < 2)
	{
		Console::WriteLine(L"Usage: CppReader path");
	    return 0;
	}
	// args[0] is the executable (filename)
	String^ path = gcnew String(args[1]);

	if (!File::Exists(path))
	{
		Console::WriteLine(L"Invalid filename!");
		return -1;
	}
	else
		Console::WriteLine("The file exist!");

	try
		{
			FileStream^ fs = gcnew FileStream(path, FileMode::Open);
			StreamReader^ sr = gcnew StreamReader(fs);

			int count = 0;
			for(;;)
			{
				String^ line  = sr->ReadLine();
				count++;

				// If there are no more lines, break out of the loop
				if (line == nullptr) break;
				Console::WriteLine(line);

				if (count % 20 == 0)
				{
					Console::Write(L"--more--");
					String^ response = Console::ReadLine();
					if (response->Equals(L"q")) break;
					count = 0;
				}				
			}
			Console::WriteLine("-- end --");
		}
	catch(System::Exception^ pe)
		{
			Console::WriteLine(pe->ToString());
		}

	return 0;
}
