// CppXmlTextReader.cpp : main project file.

#include "stdafx.h"
#using <System.xml.dll>

using namespace System;
using namespace System::Xml;
using namespace System::Xml::Schema;

// Validation handler class 
ref class ValHandler
{
	public:
		static void ValidationHandler(Object^ pSender, ValidationEventArgs^ pe)
		{
			Console::WriteLine(L"Validation Event: {0}", pe->Message);
		}
};

int main()
{
	// Get the command line arguments
	array<String^>^args = Environment::GetCommandLineArgs();

	// Check for required arguments
	if (args->Length < 2)
	{
		Console::WriteLine(L"Usage: CppXmlTextReader path");
		return -1;
	}

	String^ path = gcnew String(args[1]);

	try
	{
		// Create the reader...
		XmlTextReader^ rdr = gcnew XmlTextReader(path);
		Console::WriteLine("Xml reader is created...");

		// Create the validating reader and set the validation type
		XmlValidatingReader^ xvr = gcnew XmlValidatingReader(rdr);
		xvr->ValidationType = ValidationType::Auto;

		// Set the handler
		xvr->ValidationEventHandler += 
			gcnew ValidationEventHandler(&ValHandler::ValidationHandler);

		// Read nodes from the XmlValidatingReader
		while (xvr->Read())
		{
			switch (xvr->NodeType)
			{
				case XmlNodeType::XmlDeclaration:
					Console::WriteLine(L"-> XML declaration");
					break;
				case XmlNodeType::Document:
					Console::WriteLine(L"-> Document node");
					break;
				case XmlNodeType::Element:
					Console::WriteLine(L"-> Element node, name={0}", xvr->Name);
					break;
				case XmlNodeType::EndElement:
					Console::WriteLine(L"-> End element node, name={0}", xvr->Name);
					break;
				case XmlNodeType::Text:
					Console::WriteLine(L"-> Text node, value={0}", xvr->Value);
					break;
				case XmlNodeType::Comment:
					Console::WriteLine(L"-> Comment node, name={0}, value={1}", xvr->Name, xvr->Value);
					break;
				case XmlNodeType::Whitespace:
					break;
				default:
					Console::WriteLine(L"** Unknown node type");
					break;
			}
		}
	}
	catch (Exception^ pe)
	{
		Console::WriteLine(pe->ToString());
	}

    return 0;
}



