// CppXmlWriter.cpp : main project file.

#include "stdafx.h"
#using <System.xml.dll>

using namespace System;
using namespace System::Xml;

int main(array<System::String ^> ^args)
{
    // Get the command line arguments
	args = Environment::GetCommandLineArgs();

	// Check for required arguments
	if (args->Length < 2)
	{
		Console::WriteLine(L"Usage: CppXmlWriter path");
		return -1;
	}
	String^ path = gcnew String(args[1]);

	try
	{
		// Create the writer...
		// Use the default encoding, unicode
		Console::WriteLine("Creating the writer...");
		XmlTextWriter^ writer = gcnew XmlTextWriter(path, nullptr);

		// Set the formatting
		Console::WriteLine("Setting the format...");
		writer->Formatting = Formatting::Indented;

		// Write the standard document start
		Console::WriteLine("Writing the standard doc format...");
		writer->WriteStartDocument();

		// Start the root element
		Console::WriteLine("Starting the root element...");
		writer->WriteStartElement(L"geology");

		// Start the volcano element
		Console::WriteLine("Starting the volcano element...");
		writer->WriteStartElement(L"volcano");

		// Do the name attribute
		Console::WriteLine("Setting the name attribute...");
		writer->WriteAttributeString(L"name", L"Mount St.Helens");
		
		// Write the location element
		Console::WriteLine("Writing the location element...");
		writer->WriteStartElement(L"location");
		writer->WriteString(L"Washington State, USA");
		writer->WriteEndElement();

		// Write the height element
		Console::WriteLine("Writing the height element...");
		writer->WriteStartElement(L"height");
		writer->WriteAttributeString(L"value", "9677");
		writer->WriteAttributeString(L"unit", "ft");
		writer->WriteEndElement();

		// Write the type element
		Console::WriteLine("Writing the type element...");
		writer->WriteStartElement(L"type");
		writer->WriteString(L"stratovolcano");
		writer->WriteEndElement();

		// Write the eruption elements
		Console::WriteLine("Writing the eruption elements...");
		writer->WriteStartElement(L"eruption");
		writer->WriteString(L"1857");
		writer->WriteEndElement();
		writer->WriteStartElement(L"eruption");
		writer->WriteString(L"1980");
		writer->WriteEndElement();

		// Write the magma element
		Console::WriteLine("Writing the magma element...");
		writer->WriteStartElement(L"magma");
		writer->WriteString(L"basalt, andesite and dacite");
		writer->WriteEndElement();

		// Close the volcano element
		Console::WriteLine("Closing the volcano element...");
		writer->WriteEndElement();
		
		// Close the root element
		Console::WriteLine("Closing the root element...");
		writer->WriteEndElement();

		// Flush and close
		Console::WriteLine("Flushing and closing...");
		writer->Flush();
		writer->Close();

	}

	catch (Exception^ pe)
	{
		Console::WriteLine(pe->ToString());
	}
    return 0;
}
