// CppXsl.cpp : main project file.

#include "stdafx.h"
#using <System.xml.dll>

using namespace System;
using namespace System::Xml;
using namespace System::Xml::XPath;
using namespace System::Xml::Xsl;

int main(array<System::String ^> ^args)
{
    // Get the command line arguments
	args = Environment::GetCommandLineArgs();

	// Check for required arguments
	if (args->Length < 3)
	{
		Console::WriteLine(L"Usage: {0} xml-file stylesheet_file", args[0]);
		return -1;
	}

	String^ path = gcnew String(args[1]);
	String^ xslpath = gcnew String(args[2]);

	try
	{
		// Create the XmlDocument to parse the file
		XmlDocument^ doc = gcnew XmlDocument();

		// Load the file
		doc->Load(path);
		Console::WriteLine(L"Document loaded");

		// Create the navigator and position it
		XPathNavigator^ nav = doc->CreateNavigator();
		nav->MoveToRoot();

		// Create the XslTransform and load it
		XslCompiledTransform^ xslt = gcnew XslCompiledTransform();
		xslt->Load(xslpath);

		// Create a writer for output
		XmlTextWriter^ xtw = gcnew XmlTextWriter(Console::Out);
		xtw->Formatting = Formatting::Indented;

		// Do the transformation
		xslt->Transform(nav, nullptr, xtw->Create("myhtml.html"));
	}
	catch(Exception^ pe)
	{
		Console::WriteLine(pe->Message);
	}

	return 0;
}

